ANALYZE_PROBLEM_PROMPT = """
Analyze the given programming problem and extract key information. Consider the following aspects:
1. Input parameters and their types
2. Expected output and its type
3. Any specific constraints or edge cases mentioned
4. The main algorithm or approach required to solve the problem

Provide a concise summary of your analysis.
"""

CODE_GENERATE_PROMPT = """
Generate a Python function that solves the given problem. Ensure the function is correct, efficient, and follows best practices.

Problem:
{problem}

Your task:
1. Analyze the problem carefully.
2. Design an efficient algorithm to solve it.
3. Implement the solution as a Python function.
4. Include comments to explain your code.
5. Ensure the function name matches the one specified in the problem.

Provide only the function implementation without any additional text.
"""

IMPROVE_SOLUTION_PROMPT = """
The previous solution failed to pass all test cases. Your task is to analyze the error and improve the solution.

Problem:
{input}

Your task:
1. Identify the issue in the failed solution.
2. Modify the code to fix the problem.
3. Ensure the improved solution is correct and efficient.
4. Maintain the original function name and signature.

Provide only the improved function implementation without any additional text.
"""